/*
 * Decompiled with CFR 0.152.
 */
package moe.score.pishockzap.pishockapi;

import com.google.gson.Gson;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import lombok.NonNull;
import moe.score.pishockzap.config.PishockZapConfig;
import moe.score.pishockzap.config.ShockDistribution;
import moe.score.pishockzap.pishockapi.OpType;
import moe.score.pishockzap.pishockapi.PiShockApi;
import moe.score.pishockzap.pishockapi.PiShockUtils;

public class WebHookApi
implements PiShockApi {
    private final Logger logger = Logger.getLogger("PiShock-Zap");
    private final Gson gson = new Gson();
    @NonNull
    private final PishockZapConfig config;
    @NonNull
    private final Executor executor;

    @Override
    public void performOp(@NonNull ShockDistribution distribution, @NonNull OpType op, int intensity, float duration) {
        Objects.requireNonNull(distribution, "distribution is marked non-null but is null");
        Objects.requireNonNull(op, "op is marked non-null but is null");
        if (!this.config.isEnabled()) {
            return;
        }
        if (this.config.isVibrationOnly()) {
            op = OpType.VIBRATE;
        }
        if (!PiShockUtils.shockParamsAreValid(intensity, duration)) {
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("operation", op.name());
        data.put("intensity", intensity);
        data.put("duration", Float.valueOf(duration));
        data.put("distribution", distribution.name());
        this.doApiCallOnThread(data);
    }

    private void doApiCallOnThread(@NonNull Map<String, Object> data) {
        Objects.requireNonNull(data, "data is marked non-null but is null");
        this.executor.execute(() -> {
            try {
                URLConnection connection = new URL(this.config.getCustomWebhookUrl()).openConnection();
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", "application/json");
                try (OutputStream outputStream = connection.getOutputStream();){
                    String json = this.gson.toJson((Object)data);
                    outputStream.write(json.getBytes());
                }
                connection.getInputStream().close();
                this.logger.info("Custom Webhook call successful, data: " + this.gson.toJson((Object)data));
            }
            catch (Exception e) {
                this.logger.warning("Custom Webhook call failed; exception thrown");
                e.printStackTrace();
            }
        });
    }

    public WebHookApi(@NonNull PishockZapConfig config, @NonNull Executor executor) {
        Objects.requireNonNull(config, "config is marked non-null but is null");
        Objects.requireNonNull(executor, "executor is marked non-null but is null");
        this.config = config;
        this.executor = executor;
    }
}

